define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.service('DirectSchedulingService', function ($http, $q, localResourceDirectoryService) {

		var DirectSchedulingService = {};

		var directBookingUrl = localResourceDirectoryService['direct-booking-eligibility-criteria'];
		var saveOptions = {};

		DirectSchedulingService.fetch = function(locationId) {
			return $http.get(directBookingUrl.replace('{site-code}', locationId));
		};

		DirectSchedulingService.save = function(data,locationId) {
				// update parameters for saving
			if(!_.isEmpty(data.link)) {
				saveOptions = {
					url: data.link[0].href,
					method: 'put'
				};
			} else {
				saveOptions = {
					url: directBookingUrl.replace('{site-code}', locationId),
					method: 'post'
				};
			}

			return $http[saveOptions.method](saveOptions.url, data);
		};

		return DirectSchedulingService;
	});
});